define([
    'modules/appointments/list-section/appointments-section-view',
    'text!modules/appointments/requested/requested-appointments.html',

    'text!modules/appointments/requested/requested-appointments-empty.html',

    'modules/appointments/requested/requested-appointments-list-view',
    'modules/appointments/requested/requested-appointments-collection',

    'jqm',
    'moment',
],
function (
    AppointmentsSectionView,
    template,
    noAppointmentsTemplate,
    RequestedAppointmentsListView,
    RequestedAppointments
) {
    'use strict';

    return AppointmentsSectionView.extend({
        template: template,
        regions: {appointmentsListRegion: '.requested-appointments-contain'},
        collectionEvents: {
            'sync': function() {
                if (this._isShown) {
                    this.showAppointmentsView();
                }
            },
        },
        // functions in AppointmentsSectionView:
        // _initializeSectionView
        onShow: function() {
            this.showAppointmentsView();
        },
        // onDestroy
        // showAppointmentsView
        onRender: function() {
            this._initializeSectionView({
                noAppointmentsTemplate: noAppointmentsTemplate,
                AppointmentsListView: RequestedAppointmentsListView,
            });
            this.onShow();
        },
    });
});
